############### ###############
## F_H5_A_total_points_all_imp
## Project: CBO
## PI: Malte Lierl
## Written by: Kamil Kouhen & Malte Lierl
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

ggplot(data=SUPERMUN_final  %>% filter(year==2020 & is.na(total_points_all_imp)==FALSE),
         aes(x = total_points_all_imp)) + 
    geom_histogram(binwidth = 5) + 
    labs(
      x = "Aggregate SUPERMUN municipal performance score, in 2020", 
      y = "Number of municipalities"
    ) +
    theme_minimal() +
    #theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
ggsave(width = 7, height = 3, filename = paste0(path, "H5_", "A_total_points_all_imp.png"), device = png,  dpi=200) 


